function [a2b,b2a,ab,idx] = unique_verts2(a,b,nhood)
%This function takes two lists of vertices and finds the vertices in each
%that is unique
%Synatax:   [a2b,b2a,ab,idx] = unique_verts(a,b);
%Input:     a = vertices list a(Note: only care about the first 3 points,
%               in a vert array
%           b = vertices list b
%           nhood = the search neighborhood, default = 0, perfect colo
%Output:    a2b = unique verts in a
%           b2a = unique verts in b
%           ab = not unique verts, a cell array, where {1,1} = not unique
%           a, and {1,2} = not unique b.
%           idx = a cell array of indexes for unique and not unique, the
%               first two cells contains the unique a & b, and the last two
%               contain the not unique ab and ba.

if nargin<3
    nhood = 0;  %default = perfect colo
end

%lets make the two data sets the same data type, or else the comparision
%will not be true, especially the case for double and single
if ~isinteger(a) && ~isinteger(b)     %if both are integer they are fine if class is different
    a_type = whos('a');
    b_type = whos('b');
    if ~strcmp(a_type,b_type)
        if isinteger(a)||isinteger(b)   %one number is integer make sure everything is integer
            if isfloat(a)
                a = int16(a);
            elseif isfloat(b)
                b = int16(b);
            end
        else    %both numbers a floats, make sure we don't compare double to single, go down to single.
            if isa(b,'double')
                b = single(b);
            elseif isa(a,'double')
                a = single(a);
            end
        end
    end
end
%find the unique verts in a
a_idx = zeros(size(a,1),1);     %preallocate
ab_idx = zeros(size(a,1),1);
%h = waitbar(0,['Analyzing Array A: ']);    %initialize progress bar.
if isempty(gcp('nocreate'))  % there is not another matlabpool on
    parpool      %initiate processes
    pool_on = 1;    %this function turned on the pool
else
    pool_on = 0;
end
parfor i = 1:size(a,1)     %remember verts are arranged in vertical arrays
    match = find_neighbors(a(i,1:3),b(:,1:3),nhood);
    if isempty(match)    %unique
        a_idx(i,1) = i;
    else    %not unique
        ab_idx(i,1) = i;
    end
    %waitbar(i/size(a,1),h,['Analyzing Array A: ',num2str(i)]); %update progress
end
%close(h)

%now create the unique array
a_idx(a_idx==0) = [];       %remove the zeros
ab_idx(ab_idx==0) = [];
a2b = a(a_idx,:);         %unique a vertices
ab{1,1} = sortrows(a(ab_idx,:));         %not unique, should be the same as b
idx{1,1} = a_idx;   %unique a index
idx{1,3} = ab_idx;  %not unique a index

%find the unique verts in b
b_idx = zeros(size(b,1),1);     %preallocate
ab_idx = zeros(size(b,1),1);
%h2 = waitbar(0,['Analyzing Array B: ']);    %initialize progress bar.
parfor j = 1:size(b,1)     %remember verts are arranged in vertical arrays
    match = find_neighbors(b(j,1:3),a(:,1:3),nhood);
    if isempty(match)    %unique
        b_idx(j,1) = j;
        else    %not unique
        ab_idx(j,1) = j;
    end
    %waitbar(j/size(b,1),h2,['Analyzing Array B: ',num2str(j)]); %update progress
end
%close(h2)
%now create the unique array
b_idx(b_idx==0) = [];       %remove the zeros
ab_idx(ab_idx==0) = [];
b2a = b(b_idx,:);         %unique a vertices
ab{1,2} = sortrows(b(ab_idx,:));         %not unique, should be the same as b
idx{1,2} = b_idx;   %unique b index
idx{1,4} = ab_idx;  %not unique b index
if pool_on
    delete(gcp('nocreate'))
end
